@echo off
set NEOFORGE_VERSION=21.1.216
:: Customized for Create Integrated
:: To use a specific Java runtime, set an environment variable named CI_JAVA to the full path of java.exe.
:: To disable automatic restarts, set an environment variable named CI_RESTART to false.
:: To install the pack without starting the server, set an environment variable named CI_INSTALL_ONLY to true.

set INSTALLER="%~dp0neoforge-%NEOFORGE_VERSION%-installer.jar"
set NEOFORGE_URL="https://maven.neoforged.net/releases/net/neoforged/neoforge/%NEOFORGE_VERSION%/neoforge-%NEOFORGE_VERSION%-installer.jar"

:JAVA
if not defined CI_JAVA (
    set CI_JAVA=java
)

"%CI_JAVA%" -version 1>nul 2>nul || (
   echo Minecraft 1.21 requires Java 21 - Java not found
   pause
   exit /b 1
)

:NEOFORGE
setlocal
cd /D "%~dp0"
if not exist "libraries" (
    echo Neoforge not installed, installing now.
    if not exist %INSTALLER% (
        echo No Neoforge installer found, downloading from %NEOFORGE_URL%
        bitsadmin.exe /rawreturn /nowrap /transfer neoforge /download /priority FOREGROUND %NEOFORGE_URL% %INSTALLER%
    )
    
    echo Running Neoforge installer.
    "%CI_JAVA%" -jar %INSTALLER% -installServer
)

if not exist "server.properties" (
    (
        echo allow-flight=true
        echo motd=Create Integrated
        echo max-tick-time=180000
    )> "server.properties"
)

if "%CI_INSTALL_ONLY%" == "true" (
    echo INSTALL_ONLY: complete
    goto:EOF
)

for /f tokens^=2-5^ delims^=.-_^" %%j in ('"%CI_JAVA%" -fullversion 2^>^&1') do set "jver=%%j"
if not %jver% geq 21  (
    echo Minecraft 1.21 requires Java 21 - found Java %jver%
    pause
    exit /b 1
) 

:START
"%CI_JAVA%" @user_jvm_args.txt @libraries\net\neoforged\neoforge\%NEOFORGE_VERSION%\win_args.txt nogui

if "%CI_RESTART%" == "false" ( 
    goto:EOF 
)

echo Restarting automatically in 10 seconds (press Ctrl + C to cancel)
timeout /t 10 /nobreak > NUL
goto:START